import pandas as pd   
from sklearn.metrics import classification_report, confusion_matrix 
import pickle
from decision_company import read_csv_file, classifier_predictions

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")    

# Predict on test set  
y_pred = classifier_predictions(log_reg, X_test)   

# Evaluate the model   
print(classification_report(y_test, y_pred))   
print(confusion_matrix(y_test, y_pred))     

pickle.dump(classification_report(y_test, y_pred),open("./ref_result/classification_report.pkl","wb"))
pickle.dump(confusion_matrix(y_test, y_pred),open("./ref_result/confusion_matrix.pkl","wb"))